<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>BILL OF LANDING</title>
    
    <link rel="stylesheet" href="<?php echo e(asset('css/bl/pdf.css')); ?>">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dom-to-image/2.6.0/dom-to-image.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.5/jspdf.min.js"></script>

    <?php
        $bl_bg = 'background: url('. asset('no-image.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
        $left = 0;
        if ($bg) {
            // $bl_bg = 'background: url('. asset('images/bl/bg-bl.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
            $bl_bg = 'background: url('. asset('images/bl/bl-bg-2480x3543-v2.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
            $left = -40;
        }
    ?>

    <style>
        body {
            font-family: "Consolas", sans-serif;
            font-size: 22px;
            min-height: 1080px;
            color: #555555;
        }
        #watermark {
            position: fixed;
            font-size: 200px;
            font-weight: bold;
            top: 45%;
            width: 100%;
            text-align: center;
            opacity: .3;
            transform: rotate(-45deg);
            transform-origin: 50% 50%;
            z-index: 0;
        }
        .page-break {
            page-break-after: always;
        }
        .delivery_agent {
            /* text-align: initial;
            max-width: initial; */
            /* width: 350px; */
        }
        .prepaid {
            width: 120px;
        }
        .c1 {
            /* left: calc(230px + <?php echo e($left); ?>px); */
            left: 90px;
        }
        .c3 {
            left: 400px;
        }
        .c4 {
            left: 560px;
        }
        .c5 {
            left: 720px;
        }.c6 {
            left: 790px;
        }
        .c7 {
            left: 910px;
        }
        .c8 {
            left: 1075px;
        }
        .c9 {
            left: 1260px;
        }
        .c10 {
            left: 1340px;
        }
        .c11 {
            left: 1440px;
        }
        .row1 {
            top: 150px;
        }
        .row2 {
            top: 340px;
        }
        .row3 {
            top: 530px;
        }
        .row4 {
            top: 630px;
        }
        .row5 {
            top: 725px;
        }
        .row6 {
            top: 805px;
        }
        .row7 {
            top: 885px;
        }
        .row8 {
            top: 990px;
        }
        .row10 {
            top: 1685px;
        }
        .row11 {
            top: 1995px;
        }
        .row12 {
            top: 2200px;
        }
        .place_issue {
            min-width: 260px;
        }
    </style>

</head>
<body>
    <?php
    // dd($data);
    $info = $bl??(!empty($data)?$data[0]:false);
    // dd($info);

    // dd($info->delivery_agent);

    // dd($bl_containers = $info->bl_containers);
    $bl_containers = $info->bl_containers;
    // dd(count($bl_containers))
    $qty_container = count($bl_containers);


    $shipper_line_1 = $info->shipper;
    $shipper_remaining = null;
    if(strpos( $info->shipper, "\n" )) list($shipper_line_1, $shipper_remaining) = explode("\n", $info->shipper, 2);

    $consignee_line_1 = $info->consignee;
    $consignee_remaining = null;
    if(strpos( $info->consignee, "\n" )) list($consignee_line_1, $consignee_remaining) = explode("\n", $info->consignee, 2);

    $notify_party_line_1 = $info->notify_party;
    $notify_party_remaining = null;
    if(strpos( $info->notify_party, "\n" )) list($notify_party_line_1, $notify_party_remaining) = explode("\n", $info->notify_party, 2);
    
    $notify_party2_line_1 = $info->notify_party2;
    $notify_party2_remaining = null;
    if (!empty($info->notify_party2)) {
        // list($notify_party2_line_1, $notify_party2_remaining) = explode("\n", $info->notify_party2, 2);
        if(strpos( $info->notify_party2, "\n" )) list($notify_party2_line_1, $notify_party2_remaining) = explode("\n", $info->notify_party2, 2);

        $notify_party_remaining .= ' *';
    }

    $shipped_on_board = $info->shipped_on_board??$info->etd;

    // dd($notify_party_line_1, $notify_party_remaining);
    ?>

    <?php if(!$info->is_final): ?>
        <div id="watermark">
            COPY B/L
        </div>
    <?php endif; ?>

    <div id="content2">
        <div class="page_1" style="<?php echo $bl_bg; ?>">
            <div class="shipper row1 c1">
                <div><strong><?php echo e($shipper_line_1); ?></strong></div>
                <div><?php echo e($shipper_remaining); ?></div>
            </div>

            <div class="consignee row2 c1">
                <div><strong><?php echo e($consignee_line_1); ?></strong></div>
                <div><?php echo e($consignee_remaining); ?></div>
            </div>

            <div class="notify_party row3 c1">
                <div><strong><?php echo e($notify_party_line_1); ?></strong></div>
                <div><?php echo e($notify_party_remaining); ?></div>
            </div>
            <div class="delivery_agent row4 c7">
                <div><strong><?php echo e($info->delivery_agent->name); ?></strong></div>
                <div><?php echo e($info->delivery_agent->address); ?>, <?php echo e($info->delivery_agent->city->name); ?> - <?php echo e($info->delivery_agent->post_code); ?>, <?php echo e($info->delivery_agent->country->name); ?></div>
                <div>Tel: <?php echo e($info->delivery_agent->tel); ?>

                    <?php if(!empty($info->delivery_agent->mobile)): ?>
                    , <?php echo e($info->delivery_agent->mobile); ?>

                    <?php endif; ?>
                </div>
                <?php if(!empty($info->delivery_agent->primary_email)): ?>
                <div>
                    Email: <?php echo e($info->delivery_agent->primary_email); ?>

                </div>
                <?php endif; ?>
            </div>

            <!--Row 5-->
            <div class="pre_carriage_vessel row5 c1"><?php echo e($info->pre_carriage_vessel); ?>&nbsp;</div>
            
            <div class="voy_no row5 c3"><?php echo e($info->voy_no_pre_carriage); ?>&nbsp;</div>
            <div class="place_of_receipt row5 c4"><?php echo e($info->place_of_receipt); ?></div>

            <!--Row 6-->
            <div class="ocean_vessel row6 c1"><strong><?php echo e($info->ocean_vessel); ?></strong></div>
            <div class="voy_no_destination row6 c3"><strong><?php echo e($info->voy_no_destination); ?></strong></div>
            <div class="place_of_loading row6 c4"><strong><?php echo e($info->place_of_loading->name); ?>, <?php echo e($info->place_of_loading->country->name); ?></strong></div>
            <div class="booking_ref_no row6 c7"><?php echo e($info->booking_ref_no); ?>&nbsp;</div>
            <div class="bl_no row6 c9"><strong><?php echo e($info->bl_no); ?></strong></div>

            <!--Row 7-->
            <div class="port_of_discharge row7 c1"><strong><?php echo e($info->port_of_discharge->name); ?>, <?php echo e($info->port_of_discharge->country->name); ?></strong></div>
            <div class="final_destination row7 c4"><strong><?php echo e($info->final_destination); ?>, <?php echo e($info->final_destination_country->name); ?></strong></div>
            <div class="shipper_ref row7 c7"><?php echo e($info->shipper_ref); ?></div>
            <?php
                $org_bl_spellout = new NumberFormatter("en", NumberFormatter::SPELLOUT);
            ?>
            <div class="original_bl row7 c9"><strong><?php echo e($info->original_bl); ?> (<?php echo e($org_bl_spellout->format($info->original_bl)); ?>)</strong></div>

                    
            <!--Row 8-->
            <div class="container_info row8 c1">
                <?php if(!empty($info->marks)): ?>
                    <div class="marks">
                        <div><strong>Shipping Marks:</strong> <?php echo e($info->marks); ?></div>
                    </div>
                <?php endif; ?>
                
                <?php if(count($bl_containers) > 6): ?>
                    <div class="as_per_rider">
                        <strong>Container Info:</strong> AS PER RIDER
                    </div>
                    
                    <?php if(!empty($info->notify_party2)): ?>
                        <div class="notify_party2">
                            Also Notify: <strong>* <?php echo e($notify_party2_line_1); ?></strong>
                            <div><?php echo e($notify_party2_remaining); ?></div>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <?php
                        $container_count = [];
                    ?>
                    <?php $__currentLoopData = $bl_containers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $container): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $container_count[$container->container_size->value] = $container_count[$container->container_size->value]??0;
                            $container_count[$container->container_size->value]++;

                            $con_additional_info = '/ ' . ($container->net_weight??'n/a') . ' / ' . ($container->measurement??'n/a');
                        ?>
                        <div class="container_list">
                            <strong><?php echo e($container->container_num); ?>(<?php echo e($container->container_size->getLabel()); ?>) / <?php echo e($container->seal_no); ?></strong>
                            <?php if(!empty($container->pack_qty)): ?>
                                <br>
                                <span><?php echo e($container->pack_qty); ?> <?php echo e($con_additional_info); ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if(!empty($info->notify_party2)): ?>
                        <div class="notify_party2">
                            Also Notify: <strong>* <?php echo e($notify_party2_line_1); ?></strong>
                            <div><?php echo e($notify_party2_remaining); ?></div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            
            <div class="qty row8 c4"><strong><?php echo e($info->qty); ?></strong></div>
            <div class="discription_of_goods row8 c5">
                
                <?php echo nl2br($info->discription_of_goods); ?>

            </div>
            <div class="weight row8 c9"><strong><?php echo e($info->weight); ?></strong></div>
            <div class="measurement row8 c11"><strong><?php echo e($info->measurement); ?></strong></div>

            <!--Row 9-->
            

            <!--Row 10-->
            <div class="freight_info row10 c1">
                <div><strong>FREIGHT <?php echo e($info->freight_type); ?></strong></div>
                <?php 
                // $fc = htmlspecialchars_decode($info->freight_and_charges);
                // $fc = html_entity_decode($fc);
                ?>  
                
                <?php echo $info->freight_and_charges; ?>

            </div>
            <div class="revenue_tons row10 c4"><?php echo e($info->revenue_tons); ?></div>
            <div class="rate row10 c6"><?php echo e($info->rate); ?></div>
            <div class="prepaid row10 c8"><strong><?php echo e($info->prepaid); ?></strong></div>
            <div class="collect row10 c10"><?php echo e($info->collect); ?></div>

            <!--Row 11-->
            <div class="ex_rate row11 c1"><?php echo e($info->ex_rate); ?></div>
            <div class="prepaid2 row11 c3"><strong><?php echo e($info->prepaid2); ?></strong></div>
            <div class="payable_at row11 c5"><strong><?php echo e($info->payable_at); ?></strong></div>
            <div class="place_issue row11 c8"><strong><?php echo e($info->place_issue); ?> <?php echo e(date("d/m/Y", strtotime($info->issue_date))); ?></strong></div>
            <div class="shipped_on_board row12 c1"><strong><?php echo e(date("d/m/Y", strtotime($shipped_on_board))); ?></strong></div>
        </div>
        <!-- --------------------- Page 2 ----------------------->
        <!-- ---------- rowP2_title ------------>
        <?php if(count($bl_containers) > 7 || !empty($info->rider_sheet)): ?>
        <div class="page-break"></div>
        <div class="page_2">
            <div class="page2_title"><strong>ATTACHED SHEET OF BL# <?php echo e($info->bl_no); ?></strong></div>
            <div class="rider_sheet">
                <h3 class="title">Rider Sheet</h3>
                <table width="100%">
                    <tr>
                        <td width="30%">Bill of Lading No</td>
                        <td> : </td>
                        <td width="67%"><?php echo e($info->bl_no); ?></td>
                    </tr>
                    <tr>
                        <td width="30%">Vessel Name</td>
                        <td> : </td>
                        <td width="67%">
                            <?php echo e(!empty($info->ocean_vessel)?($info->ocean_vessel . ' (V.'. $info->voy_no_destination .')'):(!empty($info->pre_carriage_vessel)?$info->pre_carriage_vessel:'No vessel selected')); ?>

                        </td>
                    </tr>
                </table>

                <?php if(count($bl_containers) > 7): ?>
                <table width="100%">
                    <thead>
                        <tr>
                            <td>Container No.</td>
                            <td>Seal No.</td>
                            <td>Size</td>
                            <td>Number Of Pkgs</td>
                            <td>Gross Weight (KG)</td>
                            <td>Net Weight (KG)</td>
                            <td>Measurement (M3)</td>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $bl_containers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $container): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($container->container_num); ?></td>
                            <td><?php echo e($container->seal_no); ?></td>
                            <td><?php echo e($container->container_size->getLabel()); ?></td>
                            <td><?php echo e($container->pack_qty); ?></td>
                            <td><?php echo e($container->gross_weight); ?></td>
                            <td><?php echo e($container->net_weight); ?></td>
                            <td><?php echo e($container->measurement); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php endif; ?>
                
                <div class="rider_sheet_content">
                    <?php
                        // dd($container_count);
                    ?>
                    <?php if(!empty($info->rider_sheet)): ?>
                        <h3>Description</h3>
                    <?php endif; ?>
                    <?php echo nl2br($info->rider_sheet); ?>

                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

</body>
</html><?php /**PATH /Users/asaduzzamansardar/Herd/customer-bl/resources/views/bls/pdf.blade.php ENDPATH**/ ?>