<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    {{-- <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" /> --}}
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>BILL OF LANDING</title>
    {{-- <link rel="stylesheet" href="/css/bl/styles.css"> --}}
    <link rel="stylesheet" href="{{asset('css/bl/styles.css')}}">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dom-to-image/2.6.0/dom-to-image.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.5/jspdf.min.js"></script>

    @php
        $bl_bg = '';
        $left = 0;
        if (isset($data[1]) && $data[1] != false) {
            $bl_bg = 'background: url('. asset('bl-bg.jpg') .') no-repeat -40px -10px;background-size: 800px;position: relative;';
            $left = -20;
        }
    @endphp

    @if (isset($_GET['print']))
        <script>
            window.print();
        </script>
    @endif

    <style>
        body {
            font-family: "Consolas", sans-serif;
            font-size: 11px;
            min-height: 1080px;
        }
        .delivery_agent {
            text-align: initial;
            max-width: initial;
            width: 350px;
        }
        .prepaid {
            width: 120px;
        }
        .c1 {
            left: calc(40px + {{$left}}px);
        }
        .c3 {
            left: 190px;
        }
        .c4 {
            left: 260px;
        }
        .c5 {
            left: 339px;
        }
        .c7 {
            left: 435px;
        }
        .c8 {
            left: 515px;
        }
        .c9 {
            left: 600px;
        }
        .c10 {
            left: 645px;
        }
        .c11 {
            left: 685px;
        }
        .row1 {
            top: 60px;
        }
        .row2 {
            top: 150px;
        }
        .row3 {
            top: 244px;
        }
        .row4 {
            top: 288px;
        }
        .row5 {
            top: 338px;
        }
        .row6 {
            top: 380px;
        }
        .row7 {
            top: 418px;
        }
        .row8 {
            top: 473px;
        }
        .row10 {
            top: 810px;
        }
        .row11 {
            top: 965px;
        }
        .place_issue {
            min-width: 260px;
        }
    </style>

</head>
<body style="{!! $bl_bg !!}">
    @php
    // dd($data);
    $info = isset($bl)?$bl:(!empty($data)?$data[0]:false);
    // dd($info);

    // dd($bl->discription_of_goods);

    // dd($bl_containers = $info->bl_containers);
    $bl_containers = $info->bl_containers;
    // dd(count($bl_containers))
    @endphp


    <div id="content2">
        <div class="shipper row1 c1">
            <div><strong>{{ $info->shipper_data->name }}</strong></div>
            <div>{{ $info->shipper_data->address }}</div>
            <div>{{ $info->shipper_data->city->name }} - {{ $info->shipper_data->post_code }}, {{ $info->shipper_data->country->name }}</div>
        </div>

        <div class="consignee row2 c1">
            <div><strong>{{ $info->consignee_data->name }}</strong></div>
            <div>{{ $info->consignee_data->address }}</div>
            <div>{{ $info->consignee_data->city->name }} - {{ $info->consignee_data->post_code }}, {{ $info->consignee_data->country->name }}</div>
        </div>

        <div class="notify_party row3 c1">
            <div><strong>{{ $info->notify_party_data->name }}</strong></div>
            <div>{{ $info->notify_party_data->address }}</div>
            <div>{{ $info->notify_party_data->city->name }} - {{ $info->notify_party_data->post_code }}, {{ $info->notify_party_data->country->name }}@if (!empty($info->notify_party2_data)) * @endif</div>
        </div>

        <div class="delivery_agent row4 c7">
            <div><strong>{{ $info->delivery_agent_data->name }}</strong></div>
            <div>{{ $info->delivery_agent_data->address }}</div>
            <div>{{ $info->delivery_agent_data->city->name }} - {{ $info->delivery_agent_data->post_code }}, {{ $info->delivery_agent_data->country->name }}</div>
            <div>Tel: {{ $info->delivery_agent_data->tel }}
                @if (!empty($info->delivery_agent_data->mobile))
                , {{ $info->delivery_agent_data->mobile }}
                @endif
            </div>
            @if (!empty($info->delivery_agent_data->primary_email))
            <div>
                Email: {{ $info->delivery_agent_data->primary_email }}
            </div>
            @endif
        </div>

        <!--Row 5-->
        <div class="pre_carriage_vessel row5 c1">{{ $info->pre_carriage_vessel_data->name }}&nbsp;</div>
        {{-- <div class="voy_no row5 c3">{{ $info->voy_no }}&nbsp;</div> --}}
        <div class="voy_no row5 c3">{{ $info->voy_no_pre_carriage }}&nbsp;</div>
        <div class="place_of_receipt row5 c4"><strong>{{ $info->place_of_receipt_data->name }}, {{ $info->place_of_receipt_data->country->name }}</strong></div>

        <!--Row 6-->
        <div class="ocean_vessel row6 c1"><strong>{{ $info->ocean_vessel_data->name }}</strong></div>
        <div class="voy_no_destination row6 c3"><strong>V.{{ $info->voy_no_destination }}</strong></div>
        <div class="place_of_loading row6 c4"><strong>{{ $info->place_of_loading_data->name }}, {{ $info->place_of_loading_data->country->name }}</strong></div>
        <div class="booking_ref_no row6 c7">{{ $info->booking_ref_no }}&nbsp;</div>
        <div class="bl_no row6 c9"><strong>{{ $info->bl_no }}</strong></div>


        <!--Row 7-->
        <div class="port_of_discharge row7 c1"><strong>{{ $info->port_of_discharge_data->name }}, {{ $info->port_of_discharge_data->country->name }}</strong></div>
        <div class="final_destination row7 c4"><strong>{{ $info->final_destination_data->name }}, {{ $info->final_destination_data->country->name }}</strong></div>
        <div class="shipper_ref row7 c7">{{ $info->shipper_ref }}</div>
        <div class="original_bl row7 c9"><strong>{{ $info->original_bl }}</strong></div>

        <!--Row 8-->
        <div class="container_info row8 c1">
            <strong>CONTAINER / SEAL NO</strong><br>
            @if (count($bl_containers) > 5)
                AS PER RIDER

                {!! $info->container_info !!}

                @if (!empty($info->notify_party2_data))
                    <div class="notify_party2">
                        <strong>* {{ $info->notify_party2_data->name }}</strong>
                        <div>{{ $info->notify_party2_data->address }}</div>
                        <div>{{ $info->notify_party2_data->city->name }} - {{ $info->notify_party2_data->post_code }}, {{ $info->notify_party2_data->country->name }}</div>
                    </div>
                @endif
            @else
                @foreach ($bl_containers as $container)
                    {{ $container->container->container_no }} / {{ $container->seal_no }}
                @endforeach

                {!! $info->container_info !!}
            @endif
        </div>
        <div class="qty row8 c4"><strong>{{ $info->qty }}</strong></div>
        <div class="discription_of_goods row8 c5">
            {{-- <textarea readonly rows="35" cols="32" style="border:0;">{!! $info->discription_of_goods !!}</textarea> --}}
            {!! $info->discription_of_goods !!}
        </div>
        <div class="weight row8 c9"><strong>{{ $info->weight }}</strong></div>
        <div class="measurement row8 c11"><strong>{{ $info->measurement }}</strong></div>

        <!--Row 9-->
        {{-- <div class="container_no row9 c1">
            <table>
                <tr>
                    <td>CONTAINER NO</td><td>C.SIZE</td><td>SEAL NO</td>
                </tr>
                @foreach ($bl_containers as $container)
                <tr>
                    <td>{{ $container->container->container_no }}</td>
                    <td>{{ $container->container->size }}</td>
                    <td>{{ $container->seal_no }}</td>
                </tr>
                @endforeach
            </table>
        </div> --}}

        <!--Row 10-->
        <div class="freight_info row10 c1">
            <div><strong>FREIGHT {{ $info->freight_type }}</strong></div>
            <?php 
            // $fc = htmlspecialchars_decode($info->freight_and_charges);
            // $fc = html_entity_decode($fc);
            ?>  
            {{-- <div><textarea readonly rows="15" cols="30" style="border:0; font-size:9px;">{!! $fc !!}</textarea></div> --}}
            {!! $info->freight_and_charges !!}
        </div>
        <div class="revenue_tons row10 c4">{{ $info->revenue_tons }}</div>
        <div class="rate row10 c6">{{ $info->rate }}</div>
        <div class="prepaid row10 c8"><strong>{{ $info->prepaid }}</strong></div>
        <div class="collect row10 c10">{{ $info->collect }}</div>

        <!--Row 11-->
        <div class="ex_rate row11 c1">{{ $info->ex_rate }}</div>
        <div class="prepaid2 row11 c3"><strong>{{ $info->prepaid2 }}</strong></div>
        <div class="payable_at row11 c5"><strong>{{ $info->payable_at_data->name }}, {{ $info->final_destination_data->country->name }}</strong></div>
        <div class="place_issue row11 c8"><strong>{{ $info->place_issue_data->name }}, {{ $info->final_destination_data->country->name }} {{ date("d/m/Y", strtotime($info->issue_date)) }}</strong></div>


        <!-- --------------------- Page 2 ----------------------->
        <!-- ---------- rowP2_title ------------>
        <div class="rowP2_title c3"><strong>ATTACHED SHEET OF BL# {{ $info->bl_no }}</strong></div>
        <div class="rowP2_body c1">

            @if (count($bl_containers) > 5)
                <h3 class="title">Rider Sheet</h3>
                <table>
                    <tr>
                        <td width="30%">Bill of Lading No</td>
                        <td> : </td>
                        <td width="67%">{{ $info->bl_no }}</td>
                    </tr>
                    <tr>
                        <td width="30%">Vessel Name</td>
                        <td> : </td>
                        <td width="67%">
                            {{ !empty($info->ocean_vessel_data)?($info->ocean_vessel_data->name . ' (V.'. $info->voy_no_destination .')'):(!empty($info->pre_carriage_vessel_data)?$info->pre_carriage_vessel_data->name:'No vessel selected') }}
                        </td>
                    </tr>
                </table>
            @endif
            
            {!! $info->discription_of_goods2 !!}
        </div>
    </div>

    <?php if(isset($_GET['pdf']) && $_GET['pdf']>0){ ?>
    <script>
        domtoimage.toPng(document.getElementById('content2')).then(function (blob) {
            var pdf = new jsPDF('l', 'pt', [$('#content2').width(), $('#content2').height()]);

            // pdf.addImage(blob, 'PNG', 0, 0, $('#content2').width(), $('#content2').height());
            pdf.save("<?=$id?>.pdf");

            // that.options.api.optionsChanged();
        });
    </script>
    <?php } ?>

</body>
</html>