<?php

use App\Enums\CompanyTypes;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('logo')->nullable();
            $table->string('dark_logo')->nullable();
            $table->enum('type', CompanyTypes::values())->default('company');
            $table->string('name', 100);
            $table->string('code')->unique();
            $table->string('address', 200);
            $table->foreignId('city_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('state_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('country_id')->nullable()->constrained()->nullOnDelete();
            $table->string('post_code', 20)->nullable();
            $table->string('website', 100)->nullable();
            $table->string('primary_email', 100)->nullable();
            $table->string('tel', 100)->nullable();
            $table->string('mobile', 100)->nullable();
            $table->text('note')->nullable();
            $table->foreignId('organization_id')->nullable()->constrained();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
