<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Bl_container>
 */
class Bl_containerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'bl_id' => rand(1, 20),
            'container_id' => rand(1, 100),
            'seal_no' => fake()->regexify('[A-Z]{5}[0-4]{3}'),
            'pack_qty' => rand(20, 30),
            'gross_weight' => rand(11111.00,99999.99),
            'net_weight' => rand(11111.00,99999.99),
            'measurement' => rand(25,29),
        ];
    }
}
