<?php

namespace App\Observers;

use App\Models\Company;
use Illuminate\Support\Facades\Storage;

class CompanyObserver
{
    /**
     * Handle the Company "created" event.
     */
    public function created(Company $company): void
    {
        //
    }

    /**
     * Handle the Company "updated" event.
     */
    public function updated(Company $company): void
    {
        if ($company->isDirty('logo') && ! is_null($company->getOriginal('logo'))) {
            Storage::disk('public')->delete($company->getOriginal('logo'));
        }
        if ($company->isDirty('dark_logo') && ! is_null($company->getOriginal('dark_logo'))) {
            Storage::disk('public')->delete($company->getOriginal('dark_logo'));
        }
    }

    /**
     * Handle the Company "deleted" event.
     */
    public function deleted(Company $company): void
    {
    }

    /**
     * Handle the Company "restored" event.
     */
    public function restored(Company $company): void
    {
        //
    }

    /**
     * Handle the Company "force deleted" event.
     */
    public function forceDeleted(Company $company): void
    {
        if (! is_null($company->logo)) {
            Storage::disk('public')->delete($company->logo);
        }
        if (! is_null($company->dark_logo)) {
            Storage::disk('public')->delete($company->dark_logo);
        }
    }
}
