<?php

namespace App\Models;

use App\Enums\ContainerSizes;
use App\Enums\ContainerTypes;
use App\Enums\ContainerPropertyTypes;
use Illuminate\Database\Eloquent\Model;
use App\Enums\ContainerStatuses;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Container extends Model
{
    use HasFactory, SoftDeletes;

    protected $casts = [
        'size' => ContainerSizes::class,
        'type' => ContainerTypes::class,
        'status' => ContainerStatuses::class,
        'property_type' => ContainerPropertyTypes::class,
    ];
}
