<?php

namespace App\Models;

use App\Enums\BLTypes;
// use Guava\FilamentDrafts\Concerns\HasDrafts;
use App\Enums\CompanyTypes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Billoflading extends Model
{
    use HasFactory, SoftDeletes;
    // use HasDrafts;

    protected $casts = [
        'bl_type' => BLTypes::class,
    ];
    
    /**
     * The "booted" method of the model.
     */
    protected static function booted(): void
    {
        // dd(Company::where('organization_id', auth()->user()->organization_id));
        static::addGlobalScope('organization', function (Builder $builder) {
            $builder->where('organization_id', auth()->user()->organization_id);
        });
    }

    /**
     * Get the company that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function company_data(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }

    /**
     * Get the warehouse that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function warehouse_data(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'warehouse_id', 'id')->where('type', CompanyTypes::WAREHOUSE);
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function shipper_data(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'shipper', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function consignee_data(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'consignee', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function notify_party_data(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'notify_party', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function notify_party2_data(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'notify_party2', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function delivery_agent(): BelongsTo
    {
        return $this->belongsTo(Office::class, 'delivery_agent_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function pre_carriage_vessel_data(): BelongsTo
    {
        return $this->belongsTo(Vessel::class, 'pre_carriage_vessel', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function ocean_vessel_data(): BelongsTo
    {
        return $this->belongsTo(Vessel::class, 'ocean_vessel', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function place_of_receipt_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'place_of_receipt', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function place_of_loading_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'place_of_loading', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port_of_discharge_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_of_discharge', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function final_destination_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'final_destination', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payable_at_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'payable_at', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function place_issue_data(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'place_issue', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function entry_by_data(): BelongsTo
    {
        return $this->belongsTo(User::class, 'entry_by', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function last_updated_by_data(): BelongsTo
    {
        return $this->belongsTo(User::class, 'last_updated_by', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function deleted_by_data(): BelongsTo
    {
        return $this->belongsTo(User::class, 'deleted_by', 'id');
    }

    /**
     * Get all of the bl_containers for the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bl_containers(): HasMany
    {
        return $this->hasMany(Bl_container::class, 'bl_id');
    }

    /**
     * Get all of the bl_containers for the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function trackings(): HasMany
    {
        return $this->hasMany(Tracking::class, 'bl_id');
    }

    /**
     * Get the shipper that owns the company
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }
}
