<?php

namespace App\Filament\Resources\BillofladingResource\Pages;

use Filament\Actions;
use App\Enums\BLTypes;
use App\Classes\QueryCount;
use App\Models\Billoflading;
use Filament\Resources\Pages\ListRecords;
use App\Filament\Resources\BillofladingResource;
use Filament\Resources\Components\Tab;

class ListBillofladings extends ListRecords
{
    protected static string $resource = BillofladingResource::class;
    protected $model = Billoflading::class;
    protected QueryCount $query_count;

    public function __construct() {
        $this->query_count = new QueryCount($this->model, 'bl_type');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            'all' => Tab::make('All')->badge($this->query_count->getBadgeCount()),
            BLTypes::SURRENDER->value => Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::SURRENDER))
                ->icon(BLTypes::SURRENDER->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::SURRENDER->value))
                ->badgeColor('primary'),
            BLTypes::ORIGINAL->value => Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::ORIGINAL))
                ->icon(BLTypes::ORIGINAL->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::ORIGINAL->value))
                ->badgeColor('secondary'),
            BLTypes::SHIPPED->value => Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::SHIPPED))
                ->icon(BLTypes::SHIPPED->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::SHIPPED->value))
                ->badgeColor('teal'),
            BLTypes::DRAFT->value => Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::DRAFT))
                ->icon(BLTypes::DRAFT->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::DRAFT->value))
                ->badgeColor('gray'),
        ];
    }
}
