<?php

namespace App\Filament\Office\Resources\PortResource\Pages;

use App\Filament\Office\Resources\PortResource;
use App\Models\Country;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreatePort extends CreateRecord
{
    protected static string $resource = PortResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $country = Country::select('name')->where('id', $data['country_id'])->first();
        $data['country_name'] = !empty($country)?$country->name:null;

        return $data;
    }
}
