<?php

namespace App\Filament\Office\Resources;

use App\Filament\Office\Resources\OrganizationResource\Pages;
use App\Filament\Office\Resources\OrganizationResource\RelationManagers;
use App\Models\Organization;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OrganizationResource extends Resource
{
    protected static ?string $model = Organization::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(100),
                Forms\Components\TextInput::make('code')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('address')
                    ->required()
                    ->maxLength(200),
                Forms\Components\TextInput::make('post_code')
                    ->maxLength(20),
                Forms\Components\TextInput::make('website')
                    ->maxLength(100),
                Forms\Components\TextInput::make('email')
                    ->email()
                    ->maxLength(100),
                Forms\Components\TextInput::make('tel')
                    ->tel()
                    ->maxLength(100),
                Forms\Components\TextInput::make('mobile')
                    ->maxLength(100),
                Forms\Components\Textarea::make('note')
                    ->maxLength(65535)
                    ->columnSpanFull(),
                // Forms\Components\DatePicker::make('start_date'),
                // Forms\Components\TextInput::make('timezone')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('financial_year_start_month')
                //     ->required()
                //     ->numeric()
                //     ->default(7),
                // Forms\Components\TextInput::make('date_format')
                //     ->required()
                //     ->numeric()
                //     ->default(2),
                // Forms\Components\TextInput::make('time_format')
                //     ->required()
                //     ->numeric()
                //     ->default(2),
                // Forms\Components\TextInput::make('transaction_edit_days')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('vat_number')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('logo')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('invoice_logo')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('invoice_footer_logo')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('light_logo')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('dark_logo')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('favicon')
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('licenses'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('code')
                    ->searchable(),
                Tables\Columns\TextColumn::make('address')
                    ->searchable(),
                Tables\Columns\TextColumn::make('post_code')
                    ->searchable(),
                Tables\Columns\TextColumn::make('website')
                    ->searchable(),
                Tables\Columns\TextColumn::make('email')
                    ->searchable(),
                Tables\Columns\TextColumn::make('tel')
                    ->searchable(),
                Tables\Columns\TextColumn::make('mobile')
                    ->searchable(),
                // Tables\Columns\TextColumn::make('start_date')
                //     ->date()
                //     ->sortable(),
                // Tables\Columns\TextColumn::make('timezone')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('financial_year_start_month')
                //     ->numeric()
                //     ->sortable(),
                // Tables\Columns\TextColumn::make('date_format')
                //     ->numeric()
                //     ->sortable(),
                // Tables\Columns\TextColumn::make('time_format')
                //     ->numeric()
                //     ->sortable(),
                // Tables\Columns\TextColumn::make('transaction_edit_days')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('vat_number')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('logo')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('invoice_logo')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('invoice_footer_logo')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('light_logo')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('dark_logo')
                //     ->searchable(),
                // Tables\Columns\TextColumn::make('favicon')
                //     ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            RelationManagers\UsersRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOrganizations::route('/'),
            'create' => Pages\CreateOrganization::route('/create'),
            'view' => Pages\ViewOrganization::route('/{record}'),
            'edit' => Pages\EditOrganization::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
