<?php

namespace App\Filament\Office\Resources\BLResource\Pages;

use Filament\Actions;
use App\Models\Office;
use App\Models\OfficeStaff;
use App\Models\Organization;
use Illuminate\Support\Facades\Auth;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Office\Resources\BLResource;

class CreateBL extends CreateRecord
{
    protected static string $resource = BLResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        $data['delivery_agent_id'] = $office?$office->id:null;

        $data['shipped_on_board'] = $data['shipped_on_board']?:$data['eta'];
        $data['issue_date'] = $data['issue_date']?:$data['eta'];

        // dd(OfficeStaff::select('office_id')->where('office_user_id', 2)->first());
        if (auth()->user()->is_customer()) {
            $org = Organization::find(Auth::user()->organization_id);
            $data['office_id'] = $org?$org->office_id:null;
        } else  {
            $office_stuff = OfficeStaff::select('office_id')->where('office_user_id', Auth::id())->first();
            $data['office_id'] = $office_stuff?$office_stuff->office_id:null;
        }
        // dd($data['office_id']);

        $data['posted_user_type'] = 2;
        $data['posted_by_user_id'] = auth()->id();
        // dd($data);

        return $data;
    }
    
    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Bill Of Lading Created')
            ->body('A New Bill Of Lading has been added successfully.');
    }
}
