<?php

namespace App\Enums;

enum Statuses: string
{
    case Booking_Released = 'Booking Released';
    case Container_Pickup = 'Container Pickup';
    case Container_Stuffing = 'Container Stuffing';
    case Container_on_board = 'Container On Board';
    case Vessel_Departure = 'Vessel Departure';
    case Vessel_ETA = 'Vessel ETA';
    case Vessel_Berth = 'Vessel Berth';
    case Container_Discharge = 'Container Discharge';
    case DO_Released = 'DO Released';
    case DO_Revalidated = 'DO Revalidated';
    case Container_Empty_Return = 'Container Empty Return';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function forSelect(): array 
    {
        return array_combine(
            array_column(self::cases(), 'value'),
            array_column(self::cases(), 'name')
        );
    }
}