<?php

use App\Enums\BLTypes;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('billofladings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('warehouse_id')->nullable()->unsigned();
            // $table->foreignId('warehouse_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->string('bl_no', 20);
            $table->enum('bl_type', BLTypes::values())->default('draft');
            // $table->enum('bl_status', ['On the way', 'On bord', 'Delivered', 'Empty Returned', 'Discharged', 'Waiting to load', 'Waiting to sail', 'Waiting for Discharge', 'Waiting for delivered'])->default('Waiting to sail');
            $table->bigInteger('bl_status')->nullable()->unsigned();

            // location_status
            $table->date('etd')->nullable()->useCurrent();
            $table->date('eta')->nullable()->useCurrent();

            $table->foreignId('shipper')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('consignee')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('notify_party')->nullable()->unsigned();
            // $table->foreignId('notify_party')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('notify_party2')->nullable()->unsigned();
            // $table->foreignId('notify_party2')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('delivery_agent')->nullable()->unsigned();
            // $table->foreignId('delivery_agent')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();
            
            $table->integer('container_tues')->unsigned()->nullable();
            
            $table->bigInteger('pre_carriage_vessel')->nullable()->unsigned();
            // $table->foreignId('pre_carriage_vessel')->nullable()->constrained('vessels')->cascadeOnUpdate()->nullOnDelete();
            $table->string('voy_no_pre_carriage', 20)->nullable();
            $table->bigInteger('place_of_receipt')->nullable()->unsigned();
            // $table->foreignId('place_of_receipt')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('ocean_vessel')->nullable()->constrained('vessels')->cascadeOnUpdate()->nullOnDelete();
            $table->string('voy_no_destination', 20)->nullable();
            $table->bigInteger('place_of_loading')->nullable()->unsigned();
            // $table->foreignId('place_of_loading')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->string('booking_ref_no', 20);
            $table->bigInteger('port_of_discharge')->nullable()->unsigned();
            // $table->foreignId('port_of_discharge')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('final_destination')->nullable()->unsigned();
            // $table->foreignId('final_destination')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->string('shipper_ref', 20)->nullable();
            $table->enum('original_bl', [0, 1, 2, 3])->nullable()->default(1);
            $table->text('container_info')->nullable();
            // container_no
            // c_size
            // comidity
            // seal_no
            $table->string('qty', 20)->nullable();
            $table->text('discription_of_goods')->nullable();
            $table->text('discription_of_goods2')->nullable();
            $table->string('weight', 20)->nullable();
            $table->string('net_weight', 20)->nullable();
            $table->string('measurement', 20)->nullable();
            
            $table->enum('freight_type', ['prepaid', 'postpaid', 'collect'])->nullable()->default('prepaid');
            $table->text('freight_and_charges')->nullable();
            
            $table->string('revenue_tons', 20)->nullable();
            $table->string('rate', 20)->nullable();
            $table->string('prepaid', 20)->nullable();
            $table->string('collect', 20)->nullable();
            $table->string('ex_rate', 20)->nullable();
            $table->string('prepaid2', 20)->nullable();
            $table->bigInteger('payable_at')->nullable()->unsigned();
            // $table->foreignId('payable_at')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('place_issue')->nullable()->unsigned();
            // $table->foreignId('place_issue')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->date('issue_date')->nullable()->useCurrent();

            $table->timestamp('do_issued_at')->useCurrent();
            $table->string('do_online_id')->nullable();
            $table->string('do_cnf_name')->nullable();
            $table->string('do_cnf_license')->nullable();

            $table->boolean('completed')->default(false);
            $table->bigInteger('completed_by')->nullable()->unsigned();
            // $table->foreignId('completed_by')->nullable()->constrained('users')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('warehouse_discharged')->nullable()->unsigned();
            // $table->foreignId('warehouse_discharged')->nullable()->constrained('warehouses')->cascadeOnUpdate()->nullOnDelete();
            

            $table->bigInteger('entry_by')->nullable()->unsigned();
            // $table->foreignId('entry_by')->nullable()->constrained('users')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('last_updated_by')->nullable()->unsigned();
            // $table->foreignId('last_updated_by')->nullable()->constrained('users')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('deleted_by')->nullable()->unsigned();
            // $table->foreignId('deleted_by')->nullable()->constrained('users')->cascadeOnUpdate()->nullOnDelete();

            $table->foreignId('organization_id')->nullable()->constrained();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('billofladings');
    }
};
