<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cities', function(Blueprint $table)
        {
            $table->id();
            $table->string('name');
            $table->mediumInteger('state_id')->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->string('state_code')->nullable();
            $table->mediumInteger('country_id')->nullable()->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->char('country_code', 3)->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->timestamps();
            $table->tinyInteger('flag')->default(1);
            $table->string('wikiDataId')->nullable()->comment('Rapid API GeoDB Cities');
        });
        $this->sql_seed();
    }

    public function sql_seed()
    {
        // cities
        $sql_dump = File::get(database_path('sql/cities.sql'));
        DB::connection()->getPdo()->exec($sql_dump);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cities');
    }
};
