<?php

namespace Database\Factories;

use App\Enums\CompanyTypes;
use Illuminate\Support\Arr;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Company>
 */
class CompanyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->unique()->company();
        $words = explode(" ", str_replace('-', ' ', $name));
        $code = '';
        foreach($words as $word){
            $code .= $word[0].$word[1];
        }

        return [
            'type' => Arr::random(CompanyTypes::cases()),
            'name' => $name,
            'code' => strtoupper($code . fake()->randomLetter()),
            'address' => fake()->streetAddress(),
            'city_id' => rand(1, 100),
            'state_id' => rand(1, 100),
            'country_id' => rand(1, 100),
            'post_code' => fake()->postcode(),
            'website' => 'example.com',
            'primary_email' => fake()->email(),
            'tel' => fake()->phoneNumber(),
            'mobile' => fake()->phoneNumberWithExtension(),
            // 'comapany_admin' => rand(1, 100),
            // 'business_id' => rand(1, 100),
            'note' => fake()->text(),
        ];
    }
}
