<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Tracking extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function bl(): BelongsTo
    {
        return $this->belongsTo(Billoflading::class, 'bl_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function vessel(): BelongsTo
    {
        return $this->belongsTo(Vessel::class, 'vessel_id', 'id');
    }
}
