<?php

namespace App\Filament\Office\Resources\PortResource;

use Filament\Forms;

final class PortForms
{
    static public function getPortAddForm() : Forms\Components\Grid {
        return Forms\Components\Grid::make('Add New Port')->schema([
            Forms\Components\TextInput::make('name')
                ->helperText('Enter full name of port here (no iso or country code).')
                ->required()
                ->minLength(2)
                ->maxLength(100),
            Forms\Components\Select::make('country_id')
                ->relationship('country', 'name')
                ->searchable()
                ->required(),
            Forms\Components\TextInput::make('latitude')->numeric(),
            Forms\Components\TextInput::make('longitude')->numeric(),
            Forms\Components\TextInput::make('iso')->label('ISO')
                ->helperText('ISO is the unique identifier for a port.')
                ->minLength(2)
                ->maxLength(3)
                ->required(),
            Forms\Components\Select::make('type')
                ->options([
                    'inland' => 'Inland',
                    'dry' => 'Dry',
                    'fishing' => 'Fishing',
                    'warm-water' => 'Warm Water',
                    'seaports' => 'Seaports',
                ]),
        ])->columns(2);
    }
}