<?php

namespace App\Filament\Office\Resources\CompanyResource\Pages;

use Filament\Actions;
use App\Models\Company;
use App\Classes\QueryCount;
use App\Enums\CompanyTypes;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Filament\Resources\Pages\ListRecords;
use App\Filament\Office\Resources\CompanyResource;

class ListCompanies extends ListRecords
{
    protected static string $resource = CompanyResource::class;
    protected $model = Company::class;
    protected QueryCount $query_count;

    public function __construct() {
        $this->query_count = new QueryCount($this->model, 'type');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            null => ListRecords\Tab::make('All')->badge($this->query_count->getBadgeCount()),
            CompanyTypes::BRANCH->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::BRANCH))
                // ->icon(CompanyTypes::BRANCH->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::BRANCH->value))
                ->badgeColor('secondary'),
            CompanyTypes::WAREHOUSE->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::WAREHOUSE))
                // ->icon(CompanyTypes::WAREHOUSE->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::WAREHOUSE->value))
                ->badgeColor('gray'),
            CompanyTypes::DEPOT->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::DEPOT))
                // ->icon(CompanyTypes::DEPOT->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::DEPOT->value))
                ->badgeColor('info'),
            CompanyTypes::AGENT->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::AGENT->value))
                // ->icon(CompanyTypes::AGENT->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::AGENT->value))
                ->badgeColor('agent'),
            CompanyTypes::CUSTOMER->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::CUSTOMER->value))
                // ->icon(CompanyTypes::CUSTOMER->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::CUSTOMER->value))
                ->badgeColor('success'),
            CompanyTypes::BANK->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::BANK->value))
                // ->icon(CompanyTypes::BANK->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::BANK->value))
                ->badgeColor('danger'),
            CompanyTypes::CNF->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('type', CompanyTypes::CNF->value))
                // ->icon(CompanyTypes::CNF->getIcon())
                ->badge($this->query_count->getBadgeCount(CompanyTypes::CNF->value))
                ->badgeColor('warning'),
        ];
    }
}
