<?php

namespace App\Filament\Office\Resources\BillofladingResource\Pages;

use Filament\Actions;
use App\Enums\BLTypes;
use App\Classes\QueryCount;
use App\Models\Billoflading;
use Filament\Resources\Pages\ListRecords;
use App\Filament\Office\Resources\BillofladingResource;

class ListBillofladings extends ListRecords
{
    protected static string $resource = BillofladingResource::class;
    protected $model = Billoflading::class;
    protected QueryCount $query_count;

    public function __construct() {
        $this->query_count = new QueryCount($this->model, 'bl_type');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            'all' => ListRecords\Tab::make('All')->badge($this->query_count->getBadgeCount()),
            BLTypes::SURRENDER->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::SURRENDER))
                ->icon(BLTypes::SURRENDER->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::SURRENDER->value))
                ->badgeColor('secondary'),
            BLTypes::ORIGINAL->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::ORIGINAL))
                ->icon(BLTypes::ORIGINAL->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::ORIGINAL->value))
                ->badgeColor('secondary'),
            BLTypes::DRAFT->value => ListRecords\Tab::make()
                ->query(fn ($query) => $query->where('bl_type', BLTypes::DRAFT))
                ->icon(BLTypes::DRAFT->getIcon())
                ->badge($this->query_count->getBadgeCount(BLTypes::DRAFT->value))
                ->badgeColor('secondary'),
        ];
    }
}
