@php
use App\Classes\TzDateTime;
    $rowItem = '';
    $thOpeing = '<th class="table-repeater-header-column p-2 font-medium first:rounded-tl-xl last:rounded-tr-xl bg-gray-100 dark:text-gray-300 dark:bg-gray-900/60 text-center">';
    $tdOpeing = '<td class="table-repeater-column p-2 text-center text-sm" style="width: auto">';
    foreach ($getState() as $itemData) {
        $rowItem .= '<tr class="table-repeater-row">';
        $rowItem .= $tdOpeing . $itemData->port_of_loading->name . ' (' . $itemData->port_of_loading->iso . ')' .'</td>';
        $rowItem .= $tdOpeing . $itemData->eta->timezone(TzDateTime::getOfficeTimeZone()->zoneName)->format('jS F Y').'</td>';
        $rowItem .= $tdOpeing . $itemData->etb->timezone(TzDateTime::getOfficeTimeZone()->zoneName)->format('jS F Y').'</td>';
        $rowItem .= $tdOpeing . $itemData->etd->timezone(TzDateTime::getOfficeTimeZone()->zoneName)->format('jS F Y').'</td>';
        $rowItem .= $tdOpeing . $itemData->cut_off_date->timezone(TzDateTime::getOfficeTimeZone()->zoneName)->format('jS F Y').'</td>';
        $rowItem .= $tdOpeing . $itemData->string.'</td>';
        $rowItem .= $tdOpeing . $itemData->reg_no.'</td>';
        $rowItem .= '</tr>';
    }
@endphp

<x-dynamic-component :component="$getEntryWrapperView()" :entry="$entry">
    <div class="table-repeater-container rounded-xl relative ring-1 ring-gray-950/5 dark:ring-white/20">
        <table class="w-full">
            <thead @class([
                        'table-repeater-header rounded-t-xl overflow-hidden border-b border-gray-950/5 dark:border-white/20',
                    ])>
                    <tr class="text-sm md:divide-x md:divide-gray-950/5 dark:md:divide-white/20">
                    {!! $thOpeing !!}
                        Port
                    </td>
                    {!! $thOpeing !!}
                        ETA
                    </td>
                    {!! $thOpeing !!}
                        ETB
                    </td>
                    {!! $thOpeing !!}
                        ETD
                    </td>
                    {!! $thOpeing !!}
                        Cut Off Date
                    </td>
                    {!! $thOpeing !!}
                        String
                    </td>
                    {!! $thOpeing !!}
                        Reg. No.
                    </td>
                </tr>
            </thead>
            <tbody
                x-sortable
                class="table-repeater-rows-wrapper divide-y divide-gray-950/5 dark:divide-white/20"
                >
                {!! $rowItem !!}
            </tbody>
        </table>
    </div>
</x-dynamic-component>
