<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Report - BLs</title>
    <script src="https://cdn.tailwindcss.com"></script>
    
    
        
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=ubuntu:400,500,600,700&display=swap" rel="stylesheet" />
    <style>
        :root {
            --font-family: 'Ubuntu';
        }
        @page {
            /* margin: 0cm 0cm;
            margin-top: 20px;
            margin-bottom: 20px; */

            size: auto;
            margin: 20mm 20mm 10mm 20mm;
        }
        header {
            height: 96px;
            color: black;
            text-align: center;
            z-index: 0;
            padding: 10px 0px;
            box-sizing: border-box;
            background-image: url(<?php echo e(asset('/images/sealloyd-logo-180x90.png')); ?>);
            background-repeat: no-repeat;
            background-position: right top;
        }
        @media print {
            header {
                background-size: 140px auto;
                background-position-y: 15px;
                background-position: 90% 15px;
            }
        }
        @media print and (max-width: 8in){
            header {
                text-align: left;
                background-position: 85% 15px;
            }
        }
        footer {
            position: absolute;
            bottom: -80px;
            left: 0px;
            right: 0px;
            height: 60px;
            color: black;
            text-align: right;
            padding: 10px 40px;
            box-sizing: border-box;
        }
        .pagenum:before {
            content: counter(page) " / " counter(pages);
        }
        footer .company {
            text-transform: capitalize;
            font-family: 'Roboto';
        }
        footer span.company_name {
            color: #293a9b;
            font-weight: bold;
        }
        
        body {
            display: block;
            padding: 0 40px;
            text-justify: inter-word;
            font-family: 'Ubuntu', 'Consolas', 'Menlo', 'Monaco', "Lucida Console", "Liberation Mono", "DejaVu Sans Mono", "Bitstream Vera Sans Mono", "Courier New", monospace, serif;
            line-height: 13px;
            font-size: 13px;
            min-height: 1080px;
            color: #555555;
            text-transform: uppercase;
            position: relative;
        }
        
        .title {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .sub_title {
            margin-bottom: 20px;
        }

        table {
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        tr {
            border: 1px solid #999999;
        }

        table thead {
            background-color: #333333;
            color: white;
        }
        tr.bl_data {
            border-bottom-color: #eee;
        }
        tr.container_list {
            background: #fafafa;
        }

        td {
            border: none;
            padding: 5px;
        }

        h3 {
            margin-top: 30px;
        }

        .optional {
            opacity: .6;
        }
        .sum_val {
            font-weight: bold;
            text-align: left;
        }
    </style>
</head>
<body>
    <header>
        <div class="content">
            <h3 class="title header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">Report - Bill of Lading</h3>
            <div class="sub_title text-base tracking-tight text-gray-950 dark:text-white sm:text-md">
                Report Type: <strong><?php echo e(Str::headline(request('report_type'))); ?></strong> | <strong><?php echo e(Str::headline(request(request('report_type')))); ?></strong> (<?php echo e(is_array($date_range)?($date_range[0]. ' - ' .$date_range[1]):'Date: ' . $date_range); ?>)
            </div>
        </div>
    </header>

    <div class="data">
        <table width="100%">
            <thead>
                <tr>
                    <td>SN</td>
                    <td>BL Number</td>
                    <td>POL - POD</td>
                    <td>Vessel</td>
                    <td>Issued</td>
                    <td>Shipped</td>
                    <td>Tues</td>
                </tr>
            </thead>
            <tbody>
                <?php
                    $sl = 0;
                    $total_tues = 0;
                    $total_container = 0;

                    $con_colors = [
                        'primary' => 'indigo',
                        'cyan' => 'cyan',
                        'teal' => 'teal',
                        'info' => 'blue',
                    ];
                ?>
                
                <?php $__currentLoopData = $bls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $sl++;

                    $total_container += $bl->container_count;
                    $total_tues += (int) $bl->container_tues;
                ?>
                
                <tr class="bl_data">
                    <td><?php echo e($sl); ?></td>
                    <td>
                        <div><?php echo e($bl->bl_no); ?></div>
                        <div class="optional">
                            <?php echo e($bl->final_destination); ?>

                        </div>
                    </td>
                    <td>
                        <div><?php echo e($bl->place_of_loading); ?> - <?php echo e($bl->port_of_discharge); ?>

                        </div>
                        <div class="optional"><?php echo e($bl->etd); ?> - <?php echo e($bl->eta); ?></div>
                    </td>
                    <td>
                        <div><?php echo e($bl->ocean_vessel); ?></div>
                        <div class="optional">
                            <?php echo e($bl->voy_no_destination); ?>

                        </div>
                    </td>
                    <td>
                        <div><?php echo e($bl->place_issue); ?></div>
                        <div class="optional">
                            <?php echo e($bl->issue_date); ?>

                        </div>
                    </td>
                    <td><?php echo e($bl->shipped_on_board); ?></td>
                    <td>
                        <div><?php echo e($bl->container_tues); ?></div>
                        <div class="optional">
                            <?php echo e($bl->container_count); ?> Units
                        </div>
                    </td>
                </tr>
                <tr class="container_list">
                    <td colspan="7">
                        <ul class="flex gap-1.5 flex-wrap">
                        <?php $__currentLoopData = $bl->bl_containers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $container): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <span class="gap-x-1 gap-y-1 inline-flex items-center rounded-md bg-<?php echo e($con_colors[$container->container_size->getColor()]); ?>-50 px-2 py-1 text-xs font-medium text-<?php echo e($con_colors[$container->container_size->getColor()]); ?>-600 ring-1 ring-inset ring-<?php echo e($con_colors[$container->container_size->getColor()]); ?>-600/10"><?php echo e(\App\Filament\Office\Resources\BLResource::container_list($container)); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <footer>
        <table width="100%">
            <tr>
                <td width="15%" class="sum_title">Total BLs</td>
                <td> : </td>
                <td width="15%" class="sum_val"><?php echo e(count($bls)); ?></td>
                <td width="15%" class="sum_title">Total Containers</td>
                <td> : </td>
                <td width="15%" class="sum_val"><?php echo e($total_container); ?> Units</td>
                <td width="15%" class="sum_title">Total TUEs</td>
                <td> : </td>
                <td width="15%" class="sum_val"><?php echo e($total_tues); ?> tues</td>
            </tr>
        </table>

        
        <div class="company">Signed for the carrier <span class="company_name">Sea Lloyd Shipping Lines Pte Ltd</span></div>
    </footer>
</body>
</html><?php /**PATH /Users/write2kawsar/Herd/customer-bl/resources/views/reports/bls.blade.php ENDPATH**/ ?>