<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title>BILL OF LANDING</title>
        <link rel="stylesheet" href="<?php echo e(asset('css/bl/pdf-low-res.css')); ?>">
    
        <?php
            $bl_bg = 'background: url('. resource_path('no-image.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
            $left = 0;
            if ($bg) {
                // $bl_bg = 'background: url('. resource_path('images/bl/bl-front-low-res.jpg') .') no-repeat;background-size: 100%;height: 100%;position: relative;';
                $bl_bg = 'background: url('. $bg_image .') no-repeat; background-size: 100%; height: 100%; position: relative;';
                $left = -40;
            }
        ?>
    
        <style>
            body {
                font-family: Consolas, Menlo, Monaco, "Lucida Console", "Liberation Mono", "DejaVu Sans Mono", "Bitstream Vera Sans Mono", "Courier New", monospace, serif;
                line-height: 11px;
                font-size: 11px;
                min-height: 1080px;
                color: #555555;
            }
            #watermark {
                position: fixed;
                font-size: 140px;
                font-weight: bold;
                top: 45%;
                width: 100%;
                text-align: center;
                opacity: .1;
                transform: rotate(-45deg);
                transform-origin: 50% 50%;
                z-index: 0;
            }
            .page-break {
                page-break-after: always;
            }
            .c1 {
                left: 45px;
            }
            .c3 {
                left: 205px;
            }
            .c4 {
                left: 268px;
            }
            .c5 {
                left: 340px;
            }
            .c5.payable_at {
                left: 350px;
            }
            .c6 {
                left: 380px;
            }
            .c7 {
                left: 440px;
            }
            .c8 {
                left: 515px;
            }
            .c9 {
                left: 605px;
            }
            .c10 {
                left: 645px;
            }
            .c11 {
                left: 690px;
            }
            .row1 {
                top: 70px;
            }
            .row2 {
                top: 160px;
            }
            .row3 {
                top: 250px;
            }
            .row4 {
                top: 295px;
            }
            .row5 {
                top: 342px;
            }
            .row6 {
                top: 382px;
            }
            .row7 {
                top: 420px;
            }
            .row8 {
                top: 470px;
            }
            .row88 {
                top: 670px;
            }
            .row10 {
                top: 800px;
            }
            .row108 {
                top: 900px;
            }
            .row11 {
                top: 955px;
            }
            .row12 {
                top: 1050px;
            }
        </style>
    </head>
    <body>
        <?php
        if (!empty($bl->notify_party2)) {
            $notify_party_remaining = ' *';
        }
        ?>
    
        <?php if(!$bl->is_final): ?>
            <div id="watermark">
                DRAFT B/L
            </div>
        <?php endif; ?>
    
        <div id="content2">
            <div class="page_1 bl page" style="<?php echo $bl_bg; ?>">
                <div class="shipper row1 c1">
                    <div><?php echo nl2br($bl->shipper); ?></div>
                </div>
    
                <div class="consignee row2 c1">
                    <div><?php echo nl2br($bl->consignee); ?></div>
                </div>
    
                <div class="notify_party row3 c1">
                    <div><?php echo nl2br($bl->notify_party); ?></div>
                </div>
                <div class="delivery_agent row4 c7">
                    <div><?php echo nl2br($bl->delivery_agent); ?></div>
                </div>
    
                <!--Row 5-->
                <div class="pre_carriage_vessel row5 c1"><?php echo e($bl->pre_carriage_vessel); ?>&nbsp;</div>
                
                <div class="voy_no row5 c3"><?php echo e($bl->voy_no_pre_carriage); ?>&nbsp;</div>
                <div class="place_of_receipt row5 c4"><?php echo e($bl->place_of_receipt); ?></div>
    
                <!--Row 6-->
                <div class="ocean_vessel row6 c1"><?php echo e($bl->ocean_vessel); ?></div>
                <div class="ocean_vessel_voy row6 c3"><?php echo e($bl->ocean_vessel_voy); ?></div>
    
                <div class="place_of_loading row6 c4"><?php echo e($bl->place_of_loading); ?></div>
    
                <div class="booking_ref_no row6 c7"><?php echo e($bl->booking_ref_no); ?></div>
                <div class="bl_no row6 c9"><strong><?php echo e($bl->bl_no); ?></strong></div>
    
                <!--Row 7-->
                <div class="port_of_discharge row7 c1"><?php echo e($bl->port_of_discharge); ?></div>
                
                <div class="final_destination row7 c4"><?php echo e($bl->final_destination); ?></div>
                <div class="shipper_ref row7 c7"><?php echo e($bl->shipper_ref); ?></div>
                <?php
                    $org_bl_spellout = new NumberFormatter("en", NumberFormatter::SPELLOUT);
                ?>
                <div class="original_bl row7 c9"><?php echo e($bl->original_bl); ?> (<?php echo e($bl->original_bl_spellout); ?>)</div>
    
                        
                <!--Row 8-->
                <div class="container_info row8 c1">
                    
                    <?php if($bl->container_count > $bl->show_no_of_container_on_bl): ?>
                        <div class="as_per_rider">
                            <strong>Container Info:</strong> AS PER RIDER
                        </div>
                    <?php else: ?>
                        <?php
                            $container_count = [];
                        ?>
                        <?php $__currentLoopData = $bl->bl_containers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $container): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $container_count[$container->container_size->value] = $container_count[$container->container_size->value]??0;
                                $container_count[$container->container_size->value]++;
    
                                $con_additional_info = '/ ' . ($container->gross_weight??'') . ' / ' . ($container->measurement??'') . ' / ' . ($container->vgm??'');
                            ?>
                            <div class="container_list">
                                <strong><?php echo e($container->container_num); ?>(<?php echo e($container->container_size->getLabel()); ?>) / <?php echo e($container->seal_no); ?></strong>
                                <?php if(!empty($container->pack_qty)): ?>
                                    <br>
                                    <span><?php echo e($container->pack_qty); ?> <?php echo e($con_additional_info); ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    
                    <?php if(!empty($bl->marks)): ?>
                        <div class="marks">
                            <?php echo nl2br($bl->marks); ?>

                        </div>
                    <?php endif; ?>
    
                    <?php if(!empty($bl->notify_party2)): ?>
                        <div class="notify_party2">
                            <div><?php echo nl2br($bl->notify_party2); ?></div>
                        </div>
                    <?php endif; ?>
                </div>
    
                <div class="qty row8 c4">
                    <?php echo e($bl->qty); ?>

                    <div class="mt-40"></div>
                    <?php if(!empty($bl->cargo_type)): ?>
                    <div class="cargo_type mt-10">
                        <?php echo e($bl->cargo_type); ?>

                    </div>
                    <?php endif; ?>
    
                    
                </div>
                <div class="discription_of_goods row8 c5">
                    <div><strong>SHIPPER'S LOAD, COUNT AND SEALED</strong></div>
                    <?php echo nl2br($bl->discription_of_goods); ?>

                </div>
                <div class="weight row8 c9">
                    <?php echo e($bl->weight); ?>

                    <?php if(!empty($bl->net_weight)): ?>
                    <div class="net_weight">
                        <div class="underline">NET WT</div>
                        <?php echo e($bl->net_weight); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <?php if(!empty($bl->rcv_for_shipment)): ?>
                <div class="rcv_for_shipment row88 c9">
                    <div class="underline">Received for Shipment</div>
                    <?php echo e($bl->rcv_for_shipment); ?>

                </div>
                <?php endif; ?>

                <div class="measurement row8 c11">
                    <?php echo e($bl->measurement); ?>

                </div>
    
                <!--Row 9-->
                
    
                <!--Row 10-->
                <div class="freight_info row10 c1">
                    <div><strong>FREIGHT <?php echo e($bl->freight_type); ?></strong></div>
                    <?php echo $bl->freight_and_charges; ?>

                </div>
                <div class="revenue_tons row10 c4"><?php echo e($bl->revenue_tons); ?></div>
                <div class="rate row10 c6"><?php echo e($bl->rate); ?></div>
                <div class="prepaid row10 c8"><?php echo e($bl->prepaid); ?></div>
                <div class="collect row10 c10"><?php echo e($bl->collect); ?></div>

                <?php if(!empty($bl->original_text)): ?>
                <div class="original_text row108 c8">
                    <?php echo e($bl->original_text); ?>

                </div>
                <?php endif; ?>
    
                <!--Row 11-->
                <div class="ex_rate row11 c1"><?php echo e($bl->ex_rate); ?></div>
                <div class="prepaid2 row11 c3"><?php echo e($bl->prepaid2); ?></div>
                <div class="payable_at row11 c5"><?php echo e($bl->payable_at); ?></div>
                <div class="place_issue row11 c8"><?php echo e($bl->place_issue); ?> <?php echo e($bl->issue_date); ?></div>
                <div class="shipped_on_board row12 c1"><strong><?php echo e($bl->shipped_on_board); ?></strong></div>
            </div>
        </div>
    </body>
</html><?php /**PATH /Users/write2kawsar/Herd/customer-bl/resources/views/bls/pdf-template.blade.php ENDPATH**/ ?>