<?php

use App\Models\BL;
use App\Mail\BLCreated;
use App\Mail\QuickMail;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BLController;
use App\Http\Controllers\TrackingController;
use App\Http\Controllers\BillofladingController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    header('Location:/app', true, 301);
    exit;

    // return redirect()->route('/app');
    // return view('welcome');
});

Route::get('/test-mail', function() {
    return (new BLCreated(BL::withoutGlobalScopes()->find(14)))->render();
});

Route::get('/shipping/bl/report', [BLController::class, 'report'])
    ->name('shipping.bl.report')
    ->middleware('auth:admin');
Route::get('/shipping/bl/{bl}', [BLController::class, 'show'])->name('shipping.bl.show');
Route::get('/shipping/bl/{bl}/?print', [BLController::class, 'show'])->name('shipping.bl.print');
Route::get('/shipping/bl/{bl}/?pdf', [BLController::class, 'show'])->name('shipping.bl.pdf');
// Route::get('/shipping/bl/{bl}/?email', [BLController::class, 'show'])->name('shipping.bl.email');

Route::get('/shipping/bl/{bl}/certificate', [BLController::class, 'certificate'])->name('shipping.bl.certificate');
Route::get('/shipping/bl/{bl}/ridersheet', [BLController::class, 'ridersheet'])->name('shipping.bl.ridersheet');

Route::get('/shipping/billofladings/{billoflading}/print', [BillofladingController::class, 'show'])->name('shipping.billofladings.print');
Route::get('/shipping/billofladings/{billoflading}/pdf', [BillofladingController::class, 'pdf'])->name('shipping.billofladings.pdf');
Route::get('/shipping/billofladings/{billoflading}/email', [BillofladingController::class, 'email'])->name('shipping.billofladings.email');


Route::get('/shipping/billofladings/{billoflading}/shipment-advice', [BillofladingController::class, 'shipment_advice'])->name('shipping.billofladings.shipment-advice');

Route::get('/tracking', [TrackingController::class, 'index'])->name('tracking.public.result');