<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('b_l_certificates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bl_id')->constrained('b_l_s')->cascadeOnUpdate()->cascadeOnDelete();
            $table->string('cer_title')->nullable();
            $table->longText('certificate');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('b_l_certificates');
    }
};
