<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trackings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bl_id')->constrained('b_l_s')->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignId('status_id')->nullable()->nullOnDelete();
            $table->foreignId('current_port')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->date('date')->default(Carbon\Carbon::now());
            // $table->enum('status', ['on_board', 'on_the_way_to_next_port', 'on_port', 'on_depot', 'do_submitted', 'delivered', 'do_returned', 'atd_pol', 'eta_pod', 'discharged', 'do_collected', 'empty_container_returned'])->nullable()->default('on_the_way_to_next_port');
            $table->string('vessel_name')->nullable();
            $table->enum('vessel_type', ['pre_carrier', 'on_carrier', 'direct_calling'])->nullable();
            $table->string('status_details')->nullable();
            $table->text('description')->nullable();

            $table->foreignId('posted_by_user_id')->nullable()->nullable()->constrained('office_users')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('last_updated_by_user_id')->nullable()->nullable()->constrained('office_users')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('deleted_by_user_id')->nullable()->constrained('office_users')->cascadeOnUpdate()->nullOnDelete();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trackings');
    }
};
