<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('b_l_containers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bl_id')->nullable()->constrained('b_l_s')->cascadeOnUpdate()->nullOnDelete();
            $table->string('container_num')->nullable();
            $table->string('container_size')->nullable();
            $table->string('seal_no')->nullable();
            $table->string('pack_qty')->nullable();
            $table->string('gross_weight')->nullable();
            $table->string('net_weight')->nullable();
            $table->string('measurement')->nullable();
            $table->string('vgm')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('b_l_containers');
    }
};
