<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bl_containers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bl_id')->nullable()->constrained('billofladings')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('container_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->string('seal_no', 100)->nullable();
            $table->string('pack_qty')->nullable();
            $table->string('gross_weight')->nullable();
            $table->string('net_weight')->nullable();
            $table->float('measurement')->nullable()->default(25.00);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bl_containers');
    }
};
