<?php

use App\Enums\ContainerStatuses;
use App\Enums\ContainerPropertyTypes;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('containers', function (Blueprint $table) {
            $table->id();
            $table->string('container_no', '25')->unique();
            $table->string('size', '25');
            $table->string('type', '25');

            $table->enum('property_type', ContainerPropertyTypes::values())->nullable()->default('own');
            
            $table->tinyInteger('free_days')->nullable()->unsigned();

            $table->boolean('available')->nullable()->default(true);
            $table->enum('status', ContainerStatuses::values())->nullable()->default('empty');
            $table->bigInteger('last_updated_by')->nullable();
            // $table->foreignId('last_updated_by')->nullable()->constrained('office_users')->cascadeOnUpdate()->nullOnDelete();
            $table->bigInteger('added_by')->nullable();
            $table->bigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('containers');
    }
};
