<?php

use App\Enums\ContainerSizes;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('slot_bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('schedule_id')->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->enum('con_size', ContainerSizes::values())->default('20_hc');
            $table->smallInteger('requested_tues')->nullable()->default(1);
            $table->smallInteger('booked_tues')->nullable()->default(1);
            $table->smallInteger('loaded_tues')->nullable()->default(1);
            $table->decimal('cost_per_tue', 5, 2)->nullable()->default(0.00);
            $table->decimal('approx_selling_price', 5, 2)->nullable()->default(0.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('slot_bookings');
    }
};
