<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->string('voy_no')->unique();
            $table->foreignId('service_route_id')->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignId('vessel_id')->constrained()->cascadeOnUpdate()->cascadeOnDelete();
            $table->foreignId('operator_id')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();

            $table->tinyInteger('active')->default(1);
            // $table->enum('status', ['sailed', 'arrived', 'berthed', 'departed'])->default('sailed');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedules');
    }
};
