<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vessels', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->unique();
            $table->string('code')->unique();
            $table->foreignId('route_start')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('route_end')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->string('capacity', 100)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vessels');
    }
};
