<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ports', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('country_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->string('country_name')->nullable();
            $table->string('latitude')->nullable();
            // $table->decimal('latitude', 10, 8)->nullable();
            $table->string('longitude')->nullable();
            // $table->decimal('longitude', 11, 8)->nullable();
            $table->string('country_port_iso')->nullable();
            $table->string('iso')->nullable();
            $table->enum('type', ['inland', 'dry', 'fishing', 'warm-water', 'seaports']);
            $table->timestamps();
            $table->softDeletes();
        });
        $this->sql_seed();
    }

    public function sql_seed()
    {
        // ports
        $sql_dump = File::get(database_path('sql/ports.sql'));
        DB::connection()->getPdo()->exec($sql_dump);
    }
    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ports');
    }
};
