<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->id();
            $table->string('country_name');
            $table->string('name');
            $table->string('code');
            $table->string('symbol')->nullable();
            $table->integer('usd_ex_rate')->unsigned()->nullable();
            // $table->string('decimal_separator')->nullable()->default('dot(.)');
            $table->integer('decimal_separator')->unsigned()->nullable()->default(1); // dot(.), comma(,)
            $table->integer('thousand_separator')->unsigned()->nullable()->default(2); // dot(.), comma(,), space
            $table->integer('number_of_decimal')->unsigned()->nullable()->default(2); // 0, 2, null
            $table->integer('symbol_position')->unsigned()->nullable()->default(2); // $123, $ 123, 123$, 123 $
            $table->boolean('is_default')->nullable()->default(false);
            $table->foreignId('country_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->timestamps();
        });
        $this->sql_seed();
    }

    public function sql_seed()
    {
        $sql_dump = File::get(database_path('sql/currencies.sql'));
        DB::connection()->getPdo()->exec($sql_dump);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};
