<?php

namespace Database\Factories;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Tracking>
 */
class TrackingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'bl_id' => rand(1, 20),
            'date' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),
            'status_id' => rand(1, 11),
            'status_details' => Str::random(rand(3,6)),
            'description' => Str::random(rand(5,10)),
        ];
    }
}
