<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Schedule>
 */
class ScheduleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $days = rand(1, 100);
        return [
            'service_route_id' => rand(1, 100),
            'vessel_id' => rand(1, 100),
            'operator_id' => rand(1, 100),

            'voy_no' => explode('-', fake()->uuid())[0],
            
            'active' => rand(0, 1),
            // 'status' => fake()->randomElement(['sailed', 'arrived', 'berthed', 'departed']),
        ];
    }
}
