<?php

namespace Database\Factories;

use App\Enums\BLTypes;
use App\Enums\ShipmentTypes;
use App\Enums\ContainerSizes;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\BL>
 */
class BLFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'invoice_to_company_id' => rand(1, 100),
            // 'warehouse_id' => rand(1, 100),
            'bl_no' => rand(10, 99) . time() . rand(10, 99),
            'bl_status' => rand(1, 11),
            'bl_type' => fake()->randomElement(BLTypes::cases()),
            // 'shipment_type' => fake()->randomElement(ShipmentTypes::cases()),
            'cargo_type' => fake()->randomElement(['lcl_lcl', 'lcl_fcl', 'fcl_fcl', 'fcl_lcl']),
            'loading_type' => fake()->randomElement(['cy_cy', 'cy_cfs', 'cfs_cfs', 'cfs_cy']),
            'etd' => fake()->dateTimeBetween('-1 week', '-1 week'),
            'eta' => fake()->dateTimeBetween('0 week', '+1 week'),
            // 'etd' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),
            // 'eta' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),

            'shipper_text' => fake()->unique()->company()."\n".fake()->address(),
            'consignee_text' => fake()->unique()->company()."\n".fake()->address(),
            'notify_party_text' => fake()->unique()->company()."\n".fake()->address(),
            // 'shipper_name' => rand(1, 100),
            // 'shipper_address' => rand(1, 100),
            // 'consignee_name' => rand(1, 100),
            // 'consignee_address' => rand(1, 100),
            // 'notify_party_name' => rand(1, 100),
            // 'notify_party_address' => rand(1, 100),

            'delivery_agent_id' => rand(1, 10),
            
            // 'container_tues' => rand(11, 999),
            
            'pre_carriage_vessel' => fake()->randomElement(['MV ', 'MT ']) . fake()->unique()->firstName() . ' ' . fake()->cityPrefix(),
            'voy_no_pre_carriage' => explode('-', fake()->uuid())[0],
            'place_of_receipt' => rand(1, 100),
            'ocean_vessel_old' => fake()->randomElement(['MV ', 'MT ']) . fake()->unique()->firstName() . ' ' . fake()->cityPrefix(),
            'voy_no_destination_old' => explode('-', fake()->uuid())[0],
            'ocean_vessel_id' => rand(1, 100),
            'ocean_vessel_voy_id' => rand(1, 100),
            'place_of_loading_id' => rand(1, 100),
            'port_of_discharge_id' => rand(1, 100),
            'final_destination' => fake()->city().', '.fake()->country(),
            'final_destination_country_id' => rand(1, 100),
            'final_destination_city_id' => rand(1, 100),
            'shipper_ref' => explode('-', fake()->uuid())[0],
            'booking_ref_no' => explode('-', fake()->uuid())[0],
            'original_bl' => rand(1, 3),
            'qty' => rand(2,99) . 'pkg',
            'discription_of_goods' => "SHIPPER’S LOAD, STOW AND COUNT (". rand(1, 25) ."X" . fake()->randomElement(ContainerSizes::values()). ") ". fake()->randomElement(ShipmentTypes::values()) ." CONTAINER
STC: ". rand(1234, 9900) ." CTNS(ONE THOUSAND SEVEN HUNDRED THIRTY FOUR CARTONS ONLY)

DESCRIPTION OF GOODS
READY MADE GARMENTS
T-SHIRT COMFY COTTON RC/RR2619
SUPERIR COTTON RC/RR2619
SUPER COTTON RC/RR2619
STYLE NO: CT51,CT52, CT54, CT60 & CT71
COLOUR: MIXED
HS CODE: 61091000
INV NO: ZSG/ORS/14/2023
DATE : 10-09-2023
EXP NO: 0862-018619-2023
DATE : 10-09-2023",

            'rider_sheet' => "SHIPPER’S LOAD, STOW AND COUNT (". rand(1, 25) ."X" . fake()->randomElement(ContainerSizes::values()). ") ". fake()->randomElement(ShipmentTypes::values()) ." CONTAINER
STC: ". rand(1234, 9900) ." CTNS(ONE THOUSAND SEVEN HUNDRED THIRTY FOUR CARTONS ONLY)

DESCRIPTION OF GOODS
READY MADE GARMENTS
T-SHIRT COMFY COTTON RC/RR2619
SUPERIR COTTON RC/RR2619
SUPER COTTON RC/RR2619
STYLE NO: CT51,CT52, CT54, CT60 & CT71
COLOUR: MIXED
HS CODE: 61091000
INV NO: ZSG/ORS/14/2023
DATE : 10-09-2023
EXP NO: 0862-018619-2023
DATE : 10-09-2023",
            'weight' => rand(200, 9999) . ' kgs',
            'net_weight' => rand(200, 9999) . ' tons',
            'measurement' => rand(200, 9999) . ' m3',
            
            'freight_type' => fake()->randomElement(['prepaid', 'postpaid', 'collect']),
            'freight_and_charges' => fake()->words(rand(4,8), true),
            
            'revenue_tons' => fake()->words(rand(1,2), true),
            'rate' => rand(111, 999),
            'prepaid' => rand(111, 999),
            'collect' => rand(111, 999),
            'ex_rate' => rand(90, 160),
            'prepaid2' => rand(111, 999),
            'payable_at' => fake()->city(),
            'place_issue' => fake()->city(),
            // 'issue_date' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),
            'issue_date' => fake()->dateTimeBetween('-1 week', '+1 week'),

            // 'entry_by' => rand(1, 100),
            // 'last_updated_by' => rand(1, 100),

            'organization_id' => rand(1,5),
            'office_id' => rand(1,10),
            'editing_time' => rand(1, 4)*24*60*60,
            'locked' => rand(0,1),
        ];
    }
}
