<?php

namespace App\Traits;
use App\Models\OfficeUser;

final class OfficeHelper
{
    public static function office_list(OfficeUser $user, array $with = ['country'], bool $format = true) : array {
        $offices = $user->office()->get();
        $list = [];
        if (!empty($offices)) {
            foreach ($offices as $office) {
                if ($format) {
                    $list[$office->id] = self::formatOffice($office, $with);
                } else {
                    $list[$office->id]['name'] = $office->name;
                    $list[$office->id]['code'] = $office->code;
                    if (in_array('country', $with)) {
                        $list[$office->id]['country'] = $office->country?->name;
                        $list[$office->id]['country_code'] = $office->country?->iso2;
                    }
                }
            }
        }
        return $list;
    }
    public static function formatOffice($office, $with=['country']) : string {
        $list = '';
        if (!empty($office)) {
            $list .= $office->name;
            $list .= in_array('country', $with)?' ⋅ ' . $office->country?->iso2. ' ' .$office->country?->emoji:'';
        }
        return $list;
    }
}
