<?php

namespace App\Traits;

use App\Models\BL;
use App\Models\OfficeUser;
use App\Models\User;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Contracts\Database\Eloquent\Builder;

trait HasBLUser
{
    protected BL $billoflading;

    public function checkBL(BL $billoflading) : self {
        $this->billoflading = $billoflading;
        return $this;
    }

    public function getOffice() {
        return $this->billoflading->office();
    }

    public function getOfficeUsers() : Collection {
        // return OfficeStaff::with(['office_user'])->where('office_id', $this->billoflading->office_id)->get();
        return OfficeUser::whereHas('office', function (Builder $query) {
            $query->where('office_id', '=', $this->billoflading->office_id);
        })->get();
        // ->whereRelation('office_staff_users', 'office_id', '=', $this->billoflading->office_id)->get();
    }

    public function getOrganization() {
        return $this->billoflading->organization()->withoutGlobalScopes();
    }

    public function getOrganizationUsers() : Collection {
        return User::where('organization_id', $this->billoflading->organization_id)->get();
    }

    function getOrganizationUsersEmail() : array {
        $organization_user = $this->getOrganizationUsers();
        return $this->emailFormat($organization_user);
    }

    function getOfficeUsersEmail() : array {
        $office_user = $this->getOfficeUsers();
        return $this->emailFormat($office_user);
    }

    function emailFormat(Collection $users) : array {
        $emails = [];
        if ($users->count()>0) {
            foreach ($users as $user) {
                $emails[$user->email] = $user->email;
            }
        }
        return $emails;
    }

    function getAllEmails($office=true, $organization=true) : array {
        $office_email = $office?$this->getOfficeUsersEmail():[];
        $organization_email = $organization?$this->getOrganizationUsersEmail():[];
        return array_merge($office_email, $organization_email);
    }
}
