<?php

namespace App\Traits;

use App\Classes\TzDateTime;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Models\Activity;

trait HasActivity
{
    public Activity $activities;
    public Model $model;
    public Collection $owner;

    public function model(Model $record) : self {
        $this->model = $record;
        return $this;
    }

    public function getLastActivity() : self {
        $this->activities = $this->model->activities()->where('event', 'created')->orWhere('event', 'updated')->with('causer')->latest()->first();
        return $this;
    }
    
    public function last() : self {
        $this->getLastActivity();
        return $this;
    }

    public function getCreatedActivity() : self {
        $this->activities = $this->model->activities()->where('event', 'created')->with('causer')->latest()->first();
        return $this;
    }

    public function getUpdatedActivity() : self {
        $this->activities = $this->model->activities()->where('event', 'updated')->with('causer')->latest()->first();
        return $this;
    }

    public function getUserType($activity=NULL) : string {
        if ($activity==NULL) $activity = $this->activities;

        $user_type = 'customer';
        if (!empty($activity->causer_type) && $activity->causer_type == 'App\Models\OfficeUser') {
            $user_type = 'office';
        }
        return $user_type;
    }

    public function getCauserName() : string|null {
        $name = !empty($this->activities->causer)?$this->activities->causer?->name:null;
        $type = $this->getUserType();

        return $name .' ('.$type.')';
    }

    public function getLastUpdatedTime() : string|null {
        return !empty($this->activities->updated_at)?$this->activities->updated_at->timezone(TzDateTime::getOfficeTimeZone()->zoneName)->format('d-M-Y h:i A'):'30-09-2024 23:55 AM';
    }

    public function owner() : Collection {
        $created = $this->getCreatedActivity();
        if (!empty($created->activities->causer_type) && !empty($created->activities->causer)) {
            $this->owner = $created->activities->causer_type::find($created->activities->causer);
        }
        return $this->owner;
    }

    public function getData($all_data=false) : array {
        $data = [
            'activities' => $this->activities,
            'user_type' => $this->getUserType(),
            'user' => $this->getCauserName(),
            'updated_time' => $this->getLastUpdatedTime(),
            'owner' => $this->owner()
        ];

        return $data;
    }
}
