<?php

namespace App\Policies;

use App\Models\User;
use App\Models\OfficeUser;
use App\Models\Billoflading;
use Illuminate\Auth\Access\Response;

class BillofladingPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User | OfficeUser $user): bool
    {
        // if(auth()->user()->is_customer()) {
        //     auth()->user()->organization_id === 
        // }
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User | OfficeUser $user, Billoflading $billoflading): Response
    {
        if(auth()->user()->is_customer()) {
            if (auth()->user()->organization_id !== $billoflading->organization_id) {
                return Response::deny('You do not have permission to edit this BL. Please contac to our admin if you still need to edit this BL.');
            }
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User | OfficeUser $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User | OfficeUser $user, Billoflading $billoflading): Response
    {
        $timediff = \Carbon\Carbon::parse($billoflading->created_at);
        $now = \Carbon\Carbon::parse(\Carbon\Carbon::now());

        if(auth()->user()->is_customer()) {
            if($billoflading->locked || $billoflading->editing_time <=  $timediff->diffInSeconds($now)) {
                return Response::deny('This BL has exceded the time limit of modification action. Please contac to our admin if you still need to edit this BL.');
            }
            if (auth()->user()->organization_id !== $billoflading->organization_id) {
                return Response::deny('You do not have permission to edit this BL. Please contac to our admin if you still need to edit this BL.');
            }
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User | OfficeUser $user, Billoflading $billoflading): Response
    {
        if(auth()->user()->is_customer()) {
            return Response::deny('You do not have permission to Delete this BL. Please contac to our admin if you still need to DELETE this BL.');
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User | OfficeUser $user, Billoflading $billoflading): bool
    {
        if(auth()->user()->is_customer()) {
            return false;
        }
        return true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User | OfficeUser $user, Billoflading $billoflading): bool
    {
        if(auth()->user()->is_customer()) {
            return false;
        }
        return true;
    }
}
