<?php

namespace App\Policies;

use App\Models\BL;
use App\Models\User;
use App\Models\OfficeUser;
use Illuminate\Auth\Access\Response;

class BLPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User | OfficeUser $user): bool
    {
        $user = auth()->user();
        if ($user->is_customer() && !empty($user->organization_id)) {
            return true;
        }
        // if (!auth()->user()->is_customer() && auth()->user()->has('office')->count() < 1) {
        //     return false;
        // }
        // return true;
        // dd($user->isAdmin() || $user->isSuperAdmin());
        // dd(count(auth()->user()->getOfficesID()) > 0);
        // dd($user->isAdmin() || $user->isSuperAdmin()) || (!$user->is_customer() && count($user->getOfficesID()) > 0);
        return !$user->is_customer() && ($user->isAdmin() || $user->isSuperAdmin() || count($user->getOfficesID()) > 0);
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User | OfficeUser $user, BL $bl): Response
    {
        if(auth()->user()->is_customer()) {
            if (auth()->user()->organization_id !== $bl->organization_id) {
                return Response::deny('You do not have permission to edit this BL. Please contact administrator if you still need to edit this BL.');
            }
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User | OfficeUser $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User | OfficeUser $user, BL $bl): Response
    {
        $timediff = \Carbon\Carbon::parse($bl->created_at);
        $now = \Carbon\Carbon::parse(\Carbon\Carbon::now());

        if(auth()->user()->is_customer()) {
            if($bl->locked || $bl->editing_time <=  $timediff->diffInSeconds($now)) {
                return Response::deny('This BL has exceded the time limit of modification action. Please contact administrator if you still need to edit this BL.');
            }
            if (auth()->user()->organization_id !== $bl->organization_id) {
                return Response::deny('You do not have permission to edit this BL. Please contact administrator if you still need to edit this BL.');
            }
            if ($bl->is_final) {
                return Response::deny('This BL is final/confirmed, you can not edit/delete this anymore. Please contact administrator if you still need access to this BL.');
            }
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User | OfficeUser $user, BL $bl): Response
    {
        if(auth()->user()->is_customer()) {
            return Response::deny('You do not have permission to Delete this BL. Please contact administrator if you still need to DELETE this BL.');
        }
        if ($bl->is_final) {
            return Response::deny('This BL is final/confirmed, you can not edit/delete this anymore. Please contact administrator if you still need access to this BL.');
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User | OfficeUser $user, BL $bl): bool
    {
        if(auth()->user()->is_customer()) {
            return false;
        }
        return true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User | OfficeUser $user, BL $bL): bool
    {
        if(auth()->user()->is_customer()) {
            return false;
        }
        return true;
    }
}
