<?php

namespace App\Observers;

use App\Models\BL;
use App\Mail\BLCreated;
use App\Traits\HasBLNumber;
use Illuminate\Support\Facades\Mail;

class BLObserver
{
    use HasBLNumber;

    /**
     * Handle the BL "created" event.
     */
    public function created(BL $bl): void
    {
        $this->updateLastNumber($bl->bl_no, $bl->place_of_loading_id, $bl->port_of_discharge_id);
        // Mail::to('itskawsar41@gmail.com')->send(new BLCreated($bl));
    }

    /**
     * Handle the BL "updated" event.
     */
    public function updated(BL $bl): void
    {
        // (new BLCreated($bl))->render();
    }

    /**
     * Handle the BL "deleted" event.
     */
    public function deleted(BL $bl): void
    {
        //
    }

    /**
     * Handle the BL "restored" event.
     */
    public function restored(BL $bl): void
    {
        //
    }

    /**
     * Handle the BL "force deleted" event.
     */
    public function forceDeleted(BL $bl): void
    {
        //
    }
}
