<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Tracking extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Get the shipper that owns the BL
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function bl(): BelongsTo
    {
        return $this->belongsTo(BL::class, 'bl_id', 'id')->withoutGlobalScopes(['organization', 'office']);
    }

    /**
     * Get the shipper that owns the port
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_id', 'id');
    }

    /**
     * Get the shipper that owns the vessel
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function vessel(): BelongsTo
    {
        return $this->belongsTo(Vessel::class, 'vessel_id', 'id');
    }

    /**
     * Get the status that owns the status
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status(): BelongsTo
    {
        return $this->belongsTo(Status::class);
    }
}
