<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ServicePorts extends Model
{
    use HasFactory;

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_id', 'id');
    }
}
