<?php

namespace App\Models;

use App\Traits\FilterableByDates;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ScheduleTransit extends Model
{
    use HasFactory, FilterableByDates;

    protected $casts = [
        'eta' => 'datetime:Y-m-d',
        'etb' => 'datetime:Y-m-d',
        'etd' => 'datetime:Y-m-d',
        'cut_off_date' => 'datetime:Y-m-d',
    ];

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function schedule(): BelongsTo
    {
        return $this->belongsTo(Schedule::class);
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function scheduleWithVesselServeice(): BelongsTo
    {
        return $this->belongsTo(Schedule::class, 'schedule_id')->with(['vessel' => function($query){
            $query->groupBy('name');
        }, 'service_route']);
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function port_of_loading(): BelongsTo
    {
        return $this->belongsTo(Port::class, 'port_of_loading_id', 'id');
    }
}
