<?php

namespace App\Models;

use App\Traits\FilterableByDates;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Schedule extends Model
{
    use HasFactory, SoftDeletes, FilterableByDates;

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function vessel(): BelongsTo
    {
        return $this->belongsTo(Vessel::class, 'vessel_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function service_route(): BelongsTo
    {
        return $this->belongsTo(ServiceRoute::class, 'service_route_id', 'id');
    }

    /**
     * Get the shipper that owns the Billoflading
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function operator(): BelongsTo
    {
        return $this->belongsTo(VesselOperator::class, 'operator_id', 'id')->with('country');
    }

    /**
     * Get all of the ScheduleTransit for the Schedule
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function transits(): HasMany
    {
        return $this->hasMany(ScheduleTransit::class)->with('port_of_loading');
    }

    /**
     * Get all of the ScheduleTransit for the Schedule
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function transitsWithPorts(): HasMany
    {
        return $this->hasMany(ScheduleTransit::class)->with(['port_of_loading', 'port_of_discharge']);
    }

    /**
     * Get all of the bookings for the Schedule
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    // public function bookings(): HasMany
    // {
    //     return $this->hasMany(ShipmentRequest::class);
    // }

    /**
     * Get all of the bls for the Vessel
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function bls(): HasMany
    {
        return $this->hasMany(BL::class, 'ocean_vessel_voy_id', 'id');
    }
}
