<?php

namespace App\Models;

use App\Enums\ContainerSizes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BLContainer extends Model
{
    use HasFactory, SoftDeletes;

    protected $casts = [
        'container_size' => ContainerSizes::class,
    ];

    /**
     * Get the shipper that owns the BL
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function bl(): BelongsTo
    {
        return $this->belongsTo(BL::class, 'bl_id', 'id');
    }
}
