<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use App\Models\BL;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Attachment;
use Illuminate\Contracts\Queue\ShouldQueue;

class WelcomeEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(public BL $shipmentRequest,)
    {
        //
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            from: new Address('jeffrey@example.com', 'Jeffrey Way'),
            // replyTo: [
            //     new Address('taylor@example.com', 'Taylor Otwell'),
            //     new Address('itskawsar@gmail.com', 'Kawsar A.'),
            // ],
            subject: 'Welcome Email',
            // tags: ['shipment'],
            // metadata: [
            //     'shipmentRequest' => $this->shipmentRequest->id,
            // ],
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.shipment.shipmentRequest',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        // dd(Attachment::fromStorage('/app/public/contacts/14/2023/09/2-pp.jpg'));
        // Attachment::fromStorage('/app/public/contacts/14/2023/09/2-pp.jpg'),
        return [
            Attachment::fromPath(storage_path('app/public/contacts/14/2023/09/2-pp.jpg')),
        ];
    }
}
