<?php

namespace App\Http\Controllers;

use App\Models\Billoflading;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;

class BillofladingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $bl = Billoflading::where('id', $id)->with([
            'company_data', 
            'warehouse_data', 
            'shipper_data', 
            'consignee_data', 
            'notify_party_data', 
            'delivery_agent_data', 
            'pre_carriage_vessel_data', 
            'ocean_vessel_data', 
            'place_of_receipt_data', 
            'place_of_loading_data', 
            'port_of_discharge_data', 
            'final_destination_data', 
            'payable_at_data', 
            'place_issue_data', 
            'entry_by_data', 
            'last_updated_by_data', 
            'deleted_by_data',
            'bl_containers',
        ])->first();
        // dd($bl);

        return view('billofladings.print', compact('bl'));
    }

    /**
     * Display the specified resource.
     */
    public function pdf(string $id)
    {
        $bl = Billoflading::where('id', $id)->with([
            'company_data', 
            'warehouse_data', 
            'shipper_data', 
            'consignee_data', 
            'notify_party_data', 
            'delivery_agent_data', 
            'pre_carriage_vessel_data', 
            'ocean_vessel_data', 
            'place_of_receipt_data', 
            'place_of_loading_data', 
            'port_of_discharge_data', 
            'final_destination_data', 
            'payable_at_data', 
            'place_issue_data', 
            'entry_by_data', 
            'last_updated_by_data', 
            'deleted_by_data',
            'bl_containers',
        ])->first();
        // dd($bl);
        // dd($bl->bl_no);
        $data = [$bl, true];

        $pdf = Pdf::loadView('billofladings.print', compact('data'));
        return $pdf->download('bl-'.$bl->bl_no.'.pdf');

        // return view('billofladings.print', compact('bl'));
    }

    /**
     * Display the specified resource.
     */
    public function email(string $id)
    {
        $bl = Billoflading::where('id', $id)->with([
            'company_data', 
            'warehouse_data', 
            'shipper_data', 
            'consignee_data', 
            'notify_party_data', 
            'delivery_agent_data', 
            'pre_carriage_vessel_data', 
            'ocean_vessel_data', 
            'place_of_receipt_data', 
            'place_of_loading_data', 
            'port_of_discharge_data', 
            'final_destination_data', 
            'payable_at_data', 
            'place_issue_data', 
            'entry_by_data', 
            'last_updated_by_data', 
            'deleted_by_data',
            'bl_containers',
        ])->first();
        // dd($bl);

        return view('billofladings.print', compact('bl'));
    }

    public function shipment_advice(string $id) {
        $bl = Billoflading::where('id', $id)->with([
            'company_data', 
            'warehouse_data', 
            'shipper_data', 
            'consignee_data', 
            'notify_party_data', 
            'delivery_agent_data', 
            'pre_carriage_vessel_data', 
            'ocean_vessel_data', 
            'place_of_receipt_data', 
            'place_of_loading_data', 
            'port_of_discharge_data', 
            'final_destination_data', 
            'payable_at_data', 
            'place_issue_data', 
            'entry_by_data', 
            'last_updated_by_data', 
            'deleted_by_data',
            'bl_containers',
        ])->first();
        // dd($bl);

        return view('billofladings.shipment_advice', compact('bl'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
