<?php

namespace App\Filament\Resources\CompanyResource\RelationManagers;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\Billoflading;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\RelationManagers\RelationManager;

class BlRelationManager extends RelationManager
{
    protected static string $relationship = 'bl';
    protected static ?string $title = 'Bill of Ladings (BLs)';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('company_id')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('company_id')
            ->columns([
                Tables\Columns\TextColumn::make('bl_no')
                    ->label('BL Number')
                    ->description(fn (Billoflading $record): string => 'ETA: '.$record->etd . ' - ETA: '.$record->eta)
                    ->searchable(),
                Tables\Columns\TextColumn::make('ocean_vessel_data.name')
                    ->label('Vessel')
                    ->description(fn (Billoflading $record): string => 'Pre-carriage: '.$record->pre_carriage_vessel_data->name)
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('port_of_discharge_data.name')
                    ->label('Discharge')
                    ->description(fn (Billoflading $record): string => 'Final Destination: '.$record->final_destination_data->name)
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('container_tues')
                    ->label('Tues.')
                    ->description(fn (Billoflading $record): string => 'Issued at: '.\Carbon\Carbon::parse($record->issue_date)->diffForHumans())
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('deleted_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }
}
